<?php include 'header.php'; ?>
<?php include '_top-header.php'; ?>

<div class="page">

    <div class="container p-0">

        <div class="profile-layout">

            <div class="start">
                <?php include '_profile-layout-side-menu.php' ?>
            </div><!-- start -->

            <div class="end">

                <div class="card flex-center flex-column d-none">
                    <div class="no-data mb-1">
                        <img src="assets/img/no-data-address.svg" class="no-data-image mb-3">
                        <p class="h6"> You don't add any locations </p>
                    </div>
                    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#add-new-address"> Add New Address </a>
                </div>

                <div class="addresses-list">

                    <div class="card">

                        <div class="flex-between">

                            <div class="w-100px h-40px rounded overflow-hidden mb-3">
                                <div class="shimmer"></div>
                            </div>

                            <div class="d-flex gap-2">
                                <div class="w-60px h-30px rounded overflow-hidden mb-3">
                                    <div class="shimmer"></div>
                                </div>
                                <div class="w-60px h-30px rounded overflow-hidden mb-3">
                                    <div class="shimmer"></div>
                                </div>

                            </div>




                        </div>

                        <div class="row text-center">
                            <div class="col-md-12">
                                <div class="d-flex">
                                    <div class="d-block w-100">
                                        <div class="w-100 h-15px rounded overflow-hidden mb-3">
                                            <div class="shimmer"></div>
                                        </div>
                                        <div class="w-100 h-15px rounded overflow-hidden mb-3">
                                            <div class="shimmer"></div>
                                        </div>
                                        <div class="w-100 h-15px rounded overflow-hidden">
                                            <div class="shimmer"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <?php for ($i = 0; $i < 3; $i++) { ?>

                        <div class="custom-control custom-radio control-border address-item mb-3 p-1 border position-relative">

                            <input type="radio" id="address<?php echo $i; ?>" name="shipping_address" class="custom-control-input" <?php echo $i == 0 ? 'checked' : ''; ?>>

                            <label class="custom-control-label line-height-1-5 w-100" for="address<?php echo $i; ?>">

                                <div class="flex-between mb-2">

                                    <div class="d-block">
                                        <span class="badge badge-primary-faded badge-sm">Fahd akhoya</span>
                                    </div>

                                    <div class="flex-start gap-2">
                                        <a href="#" class="btn btn-outline-primary btn-sm" data-toggle="modal" data-target="#edit-address-modal">Edit</a>
                                        <a href="#" class="btn btn-danger-faded btn-sm text-danger" data-toggle="modal" data-target="#delete-address-modal">
                                            <i class="icon icon-trash"></i>
                                        </a>
                                    </div>

                                </div>


                                <div class="mb-1 flex-start">
                                    <div class="text-gray">Receiver name : </div>
                                    <div class="ms-3">Fahd Abdulaziz abo salman</div>
                                </div>

                                <div class="mb-1 flex-start">
                                    <div class="text-gray">Address details : </div>
                                    <div class="ms-3">Kuwait, Hwayli, Elsafa Walmarwa, Building 4, Apt.45</div>
                                </div>

                                <div class="mb-1 flex-start">
                                    <div class="text-gray">Phone number : </div>
                                    <div class="ms-3">+966 2345626363</div>
                                </div>

                            </label>

                        </div>

                    <?php } ?>

                </div> <!--  addresses-list -->

                <div class="text-center d-none">
                    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#add-new-address"> Add New Address </a>
                </div>

                <div class="text-center d-none">
                    <a href="#" class="btn btn-primary disabled" data-toggle="modal" data-target="#add-new-address"> Add New Address </a>
                    <p class="color-danger"> Maximum saved addresses : 5 Addresses </p>
                </div>

            </div> <!-- end -->

        </div> <!-- profile-layout -->

    </div> <!-- container -->

</div> <!-- page -->

<?php include 'footer.php'; ?>


<div class="modal fade" id="edit-address-modal" tabindex="-1">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title center"> Edit address </h5>
                <i class="icon icon-close-circle close-modal" data-dismiss="modal"></i>
            </div>

            <div class="modal-body">

                <p class="mb-2 bold"> Address Details </p>

                <div class="form-group mb-2">
                    <label> Title </label>
                    <input type="text" class="form-control" placeholder="Title" value="Home Address">
                </div>

                <div class="row mb-2">
                    <div class="col-md-6">
                        <div class="form-group mb-0">
                            <label> First name </label>
                            <input type="text" class="form-control" placeholder="First name" value="Fahd">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-0">
                            <label> Last name </label>
                            <input type="text" class="form-control" placeholder="Last name" value="Abdulaziz">
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Country </label>
                            <select class="form-control select2">
                                <option value="01" selected>Kuwait City</option>
                                <option value="02">Hawalli</option>
                                <option value="03">Salmiya</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> City </label>
                            <select class="form-control select2">
                                <option value="01" selected>Elsafa Walmarwa</option>
                                <option value="02">Al Salam</option>
                                <option value="03">Al Qibla</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-2">
                    <label> Street name </label>
                    <input type="text" class="form-control" placeholder="Street name" value="Block 4, Street 23">
                </div>

                <div class="form-group mb-2">
                    <label> Building number </label>
                    <input type="text" class="form-control" placeholder="Building number" value="45">
                </div>

                <div class="row mb-2">
                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Apt. no </label>
                            <input type="text" class="form-control" placeholder="Apt. no" value="12">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Floor (optional) </label>
                            <input type="text" class="form-control" placeholder="Floor (optional)" value="3">
                        </div>
                    </div>
                </div>

                <div class="form-group mb-2">
                    <label> Address description (optional) </label>
                    <input type="text" class="form-control" placeholder="Address description (optional)" value="Near Al-Rashed Mall">
                </div>

                <div class="form-group mb-2">

                    <label> Phone Number </label>

                    <div class="relative">

                        <input type="text" class="form-control input-with-country-code" placeholder="Phone Number" required="" value="2345626363">

                        <div class="country-code-container">

                            <select class="d-none" name="country" id="country">
                                <option value="001"> 001 </option>
                                <option value="002" selected> 002 </option>
                                <option value="003"> 003 </option>
                            </select>

                            <div class="dropdown">

                                <button class="reset-btn dropdown-toggle" type="button" id="choose-country-btn" data-toggle="dropdown">
                                    <img alt="" src="assets/img/flag-ksa.png" /> +966
                                    <i class="icon icon-chevron-down"></i>
                                </button>

                                <div class="dropdown-menu choose-country-list" aria-labelledby="choose-country-btn">
                                    <a data-value="1" class="dropdown-item" href="#"><img alt="" src="assets/img/flag-kuwait.png" /> +001 </a>
                                    <a data-value="2" class="dropdown-item active" href="#"><img alt="" src="assets/img/flag-ksa.png" /> +966 </a>
                                    <a data-value="3" class="dropdown-item" href="#"><img alt="" src="assets/img/flag-uae.png" /> +003 </a>
                                </div>

                            </div> <!-- dropdown -->

                        </div><!-- country-code-container -->

                    </div>

                </div><!-- form-group  -->

                <p class="mb-2 bold"> Address Type </p>

                <div class="attributes-options default mb-2">

                    <label class="option-container option-inline">
                        <input type="radio" name="size" value="1">
                        <span class="checkmark"> House </span>
                    </label>

                    <label class="option-container option-inline">
                        <input type="radio" checked="checked" name="size" value="2">
                        <span class="checkmark"> Apartment </span>

                    </label>

                    <label class="option-container option-inline">
                        <input type="radio" name="size" value="3">
                        <span class="checkmark"> Office </span>

                    </label>

                </div>

                <div class="modal-buttons text-center">
                    <button class="btn btn-primary w-100" data-dismiss="modal"> Save Changes </button>
                </div>

            </div>

        </div> <!-- modal-content -->
    </div> <!-- modal-dialog -->
</div> <!-- modal -->

<div class="modal fade" id="add-new-address" tabindex="-1">

    <div class="modal-dialog modal-md">

        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title center"> Add new address </h5>
                <i class="icon icon-close-circle close-modal" data-dismiss="modal"></i>
            </div>

            <div class="modal-body">

                <p class="mb-2 bold"> Address Details </p>

                <div class="form-group mb-2">
                    <label> Title </label>
                    <input type="text" class="form-control" placeholder="Title">
                </div>

                <div class="row mb-2">
                    <div class="col-md-6">
                        <div class="form-group mb-0">
                            <label> First name </label>
                            <input type="text" class="form-control" placeholder="First name">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-0">
                            <label> Last name </label>
                            <input type="text" class="form-control" placeholder="Last name">
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Country </label>
                            <select class="form-control select2">
                                <option value="01">Governorate 01</option>
                                <option value="02">Governorate 02</option>
                                <option value="03">Governorate 03</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Area </label>
                            <select class="form-control select2">
                                <option value="01">Area 01</option>
                                <option value="02">Area 02</option>
                                <option value="03">Area 03</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-2">
                    <label> Street name </label>
                    <input type="text" class="form-control" placeholder=" Street name">
                </div>

                <div class="form-group mb-2">
                    <label> Building number </label>
                    <input type="text" class="form-control" placeholder="Building number">
                </div>

                <div class="row mb-2">
                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Apt. no </label>
                            <input type="text" class="form-control" placeholder="Apt. no">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group mb-0">
                            <label> Floor (optional) </label>
                            <input type="text" class="form-control" placeholder="Floor (optional)">
                        </div>
                    </div>
                </div>

                <div class="form-group mb-2">
                    <label> Address description (optional) </label>
                    <input type="text" class="form-control" placeholder="Address description (optional)">
                </div>

                <div class="form-group mb-2">

                    <label> Phone Number</label>

                    <div class="relative">

                        <input type="text" class="form-control input-with-country-code" placeholder="Phone Number" required="">

                        <div class="country-code-container">

                            <select class="d-none" name="country" id="country">
                                <option value="001"> 001 </option>
                                <option value="002"> 002 </option>
                                <option value="003"> 003 </option>
                            </select>

                            <div class="dropdown">
                                <button class="reset-btn dropdown-toggle" type="button" id="choose-country-btn" data-toggle="dropdown">
                                    <img alt="" src="assets/img/flag-kuwait.png" /> +001
                                    <i class="icon icon-chevron-down"></i>
                                </button>

                                <div class="dropdown-menu choose-country-list" aria-labelledby="choose-country-btn">
                                    <a data-value="1" class="dropdown-item" href="#"><img alt="" src="assets/img/flag-kuwait.png" /> +001 </a>
                                    <a data-value="2" class="dropdown-item " href="#"><img alt="" src="assets/img/flag-ksa.png" /> +002 </a>
                                    <a data-value="3" class="dropdown-item " href="#"><img alt="" src="assets/img/flag-uae.png" /> +003 </a>
                                </div>
                            </div> <!-- dropdown -->

                        </div><!-- country-code-container -->

                    </div>

                </div><!-- form-group  -->

                <p class="mb-2 bold"> Address Type </p>

                <div class="attributes-options default mb-2">

                    <label class="option-container option-inline">
                        <input type="radio" checked="checked" name="size" value="1">
                        <span class="checkmark"> House </span>
                    </label>

                    <label class="option-container option-inline">
                        <input type="radio" name="size" value="2">
                        <span class="checkmark"> Apartment </span>

                    </label>

                    <label class="option-container option-inline">
                        <input type="radio" name="size" value="3">
                        <span class="checkmark"> Office </span>

                    </label>



                </div>

                <div class="modal-buttons text-center">
                    <button class="btn btn-primary w-100" data-dismiss="modal"> Add </button>
                </div>

            </div>

        </div> <!-- modal-content -->
    </div> <!-- modal-dialog -->
</div> <!-- modal -->

<div class="modal fade" id="delete-address-modal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">

            <div class="modal-body">
                <h6 class="bold text-center mb-3"> Are you sure you want to delete your address ? </h6>
                <p class="text-center color-gray"> Once you hit the delete button, there's no way to recover it, Take a moment to think about it and make sure you're 100% sure before you proceed </p>

                <div class="modal-buttons text-center">
                    <button class="btn btn-primary w-100 mb-2" data-dismiss="modal"> Keep your Address </button>
                    <button class="btn btn-outline-primary w-100" data-dismiss="modal"> Yes, Delete </button>
                </div>

            </div>




        </div> <!-- modal-content -->
    </div> <!-- modal-dialog -->
</div> <!-- modal -->